const bcrypt = require('bcrypt');
const jwt = require('jsonwebtoken');
require('dotenv').config();

class EncryptionUtil {
    
    // تشفير كلمة المرور
    static async hashPassword(plainPassword) {
        return await bcrypt.hash(plainPassword, 10);
    }

    // مقارنة كلمة المرور
    static async comparePassword(plainPassword, storedHash) {
        return await bcrypt.compare(plainPassword, storedHash);
    }

    // إنشاء توكن (JWT)
    static generateToken(user) {
        return jwt.sign(
            { id: user.id, email: user.email, role: user.role },
            process.env.JWT_SECRET,
            { expiresIn: '8h' }
        );
    }
}

module.exports = EncryptionUtil;