const express = require('express');
const path = require('path');
const cors = require('cors');
require('dotenv').config();

const db = require('./config/db'); // للتأكد من الاتصال
const authRoutes = require('./routes/authRoutes');
const assetRoutes = require('./routes/assetRoutes');

const app = express();
const PORT = process.env.PORT || 3000;

// --- Middlewares ---
app.use(express.json()); // لفهم بيانات JSON
app.use(cors());         // للسماح بالاتصال من المتصفح

// --- تقديم ملفات الواجهة الأمامية (Frontend) ---
app.use(express.static(path.join(__dirname, '../public')));

// --- مسارات الـ API (Backend) ---
app.use('/api/auth', authRoutes);
app.use('/api/assets', assetRoutes);

// --- توجيه الصفحات ---

// الصفحة الرئيسية (تسجيل الدخول)
app.get('/', (req, res) => {
    res.sendFile(path.join(__dirname, '../public/index.html'));
});

// صفحة لوحة التحكم (محمية نظرياً بالواجهة، وعملياً بالـ API)
app.get('/dashboard', (req, res) => {
    res.sendFile(path.join(__dirname, '../public/dashboard.html'));
});

// ... (أكواد سابقة)

// === 🧪 رابط اختبار اتصال قاعدة البيانات ===
app.get('/test-db', async (req, res) => {
    try {
        // محاولة تنفيذ استعلام بسيط جداً
        const [rows] = await db.query('SELECT 1 + 1 AS result');
        
        // إذا نجح الاستعلام
        res.status(200).send(`
            <h1 style="color: green; text-align: center; font-family: sans-serif;">
                ✅ الاتصال بقاعدة البيانات سليم!
            </h1>
            <p style="text-align: center;">جواب قاعدة البيانات للمعادلة (1+1) هو: <strong>${rows[0].result}</strong></p>
        `);
    } catch (error) {
        // إذا فشل الاستعلام
        console.error('خطأ قاعدة البيانات:', error);
        res.status(500).send(`
            <h1 style="color: red; text-align: center; font-family: sans-serif;">
                ❌ فشل الاتصال بقاعدة البيانات
            </h1>
            <p style="text-align: center;">السبب: ${error.message}</p>
        `);
    }
});

// ... (أكواد app.listen)


// --- تشغيل السيرفر ---
app.listen(PORT, () => {
    console.log(`
    =========================================
    🚀 النظام يعمل الآن بنجاح!
    📡 الرابط: http://localhost:${PORT}
    =========================================
    `);
});