const express = require('express');
const router = express.Router();
const AssetController = require('../controllers/assetController');
const AgentController = require('../controllers/agentController'); 
const authenticateToken = require('../middleware/authMiddleware');
const LogModel = require('../models/logModel');
const SystemController = require('../controllers/systemController');

// ============================================================
// 🟢 المنطقة العامة (Public Zone) - لا تطلب تسجيل دخول
// ============================================================

// هذا الرابط مفتوح ليستطيع "الايجنت" إرسال البيانات دون توكن
router.post('/agent/report', AgentController.receiveReport);


// ============================================================
// 🔒 منطقة الحماية (Protected Zone) - تتطلب تسجيل دخول
// ============================================================

// نقطة التفتيش: أي رابط تحت هذا السطر يتطلب (Token)
router.use(authenticateToken);

// --- مسارات إدارة الأصول ---
router.get('/', AssetController.getAll);       // جلب الكل
router.post('/', AssetController.create);      // إضافة جديد
router.put('/:id', AssetController.update);    // تعديل
router.delete('/:id', AssetController.delete); // حذف
router.post('/bulk-import', AssetController.importBulk);
// مسارات النظام
router.get('/system/health', SystemController.getHealth);
router.get('/system/settings', SystemController.getSettings);
router.post('/system/settings', SystemController.saveSettings);
// --- مسار السجلات ---
router.get('/logs/activity', async (req, res) => {
    try {
        const logs = await LogModel.getRecentLogs();
        res.json(logs);
    } catch (error) {
        res.status(500).json({ message: 'فشل جلب السجلات' });
    }
});

module.exports = router;