const db = require('../config/db');

class UserModel {
    
    // البحث عن مستخدم بالإيميل (لتسجيل الدخول)
    static async findByEmail(email) {
        const [rows] = await db.query('SELECT * FROM users WHERE email = ?', [email]);
        return rows[0];
    }

    // البحث عن مستخدم بالـ ID (للتحقق من التوكن)
    static async findById(id) {
        const [rows] = await db.query('SELECT * FROM users WHERE id = ?', [id]);
        return rows[0];
    }

    // إنشاء مستخدم جديد
    static async createUser(username, email, passwordHash, role = 'user') {
        const [result] = await db.query(
            'INSERT INTO users (username, email, password_hash, role) VALUES (?, ?, ?, ?)',
            [username, email, passwordHash, role]
        );
        return result.insertId;
    }

    // حفظ رمز OTP وصلاحيته
    static async saveOtp(userId, otpCode, expiryDate) {
        await db.query(
            'UPDATE users SET otp_code = ?, otp_expiry = ? WHERE id = ?',
            [otpCode, expiryDate, userId]
        );
    }

    // مسح رمز OTP بعد الاستخدام
    static async clearOtp(userId) {
        await db.query(
            'UPDATE users SET otp_code = NULL, otp_expiry = NULL WHERE id = ?',
            [userId]
        );
    }
}

module.exports = UserModel;