const db = require('../config/db');

class LogModel {
    
    // تسجيل عملية جديدة
    static async createLog(userId, username, action, targetId, details) {
        try {
            await db.query(
                'INSERT INTO activity_logs (user_id, username, action, target_id, details) VALUES (?, ?, ?, ?, ?)',
                [userId, username, action, targetId, details]
            );
        } catch (error) {
            console.error('❌ فشل حفظ السجل:', error);
            // لا نوقف النظام إذا فشل السجل، فقط نطبع خطأ
        }
    }

    // جلب آخر السجلات (لعرضها في الداشبورد)
    static async getRecentLogs(limit = 20) {
        const [rows] = await db.query('SELECT * FROM activity_logs ORDER BY created_at DESC LIMIT ?', [limit]);
        return rows;
    }
}

module.exports = LogModel;