const db = require('../config/db');

class AssetModel {
    

// ... (الأكواد السابقة)

    // تحديث بيانات أصل موجود
    static async updateAsset(id, data) {
        const sql = `
            UPDATE assets 
            SET code = ?, name = ?, category = ?, branch = ?, 
                location = ?, value = ?, status = ?
            WHERE id = ?
        `;
        
        const params = [
            data.code, 
            data.name, 
            data.category, 
            data.branch, 
            data.location, 
            data.value, 
            data.status, 
            id
        ];

        try {
            const [result] = await db.query(sql, params);
            return result.affectedRows > 0;
        } catch (error) {
            console.error("❌ خطأ SQL أثناء التحديث:", error.message);
            throw error;
        }
    }

// ... (باقي الكلاس)


    // جلب جميع الأصول
    static async getAllAssets() {
        try {
            // نستخدم استعلام بسيط جداً للتأكد
            const [rows] = await db.query('SELECT * FROM assets');
            return rows;
        } catch (error) {
            console.error("❌ خطأ SQL أثناء جلب الأصول:", error.message);
            throw error;
        }
    }

    // إضافة أصل جديد
    static async createAsset(data) {
        // التأكد من تطابق الحقول مع قاعدة البيانات
        const sql = `
            INSERT INTO assets (
                code, name, category, branch, location, 
                value, status, created_by
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)
        `;
        
        // القيم الافتراضية لتجنب الأخطاء
        const params = [
            data.code, 
            data.name, 
            data.category, 
            data.branch, 
            data.location || 'غير محدد',
            data.value || 0,
            data.status || 'نشط',
            data.createdBy || null
        ];

        try {
            const [result] = await db.query(sql, params);
            return result.insertId;
        } catch (error) {
            console.error("❌ خطأ SQL أثناء الإضافة:", error.message);
            throw error;
        }
    }

    // حذف أصل
    static async deleteAsset(id) {
        const [result] = await db.query('DELETE FROM assets WHERE id = ?', [id]);
        return result.affectedRows > 0;
    }
// إدخال مجموعة أصول دفعة واحدة (Bulk Insert)
    static async createBulk(assetsArray, userId) {
        if (assetsArray.length === 0) return 0;

        // تجهيز القيم للإدخال
        const values = assetsArray.map(asset => [
            asset.code,
            asset.name,
            asset.category || 'غير محدد',
            asset.branch || 'الرياض',
            asset.location || 'المستودع',
            asset.value || 0,
            asset.status || 'نشط',
            userId
        ]);

        const sql = `
            INSERT INTO assets (code, name, category, branch, location, value, status, created_by) 
            VALUES ?
        `;

        try {
            // query يقبل مصفوفة من المصفوفات للإدخال المتعدد
            const [result] = await db.query(sql, [values]);
            return result.affectedRows;
        } catch (error) {
            console.error("❌ خطأ في الإدخال المجمع:", error.message);
            throw error; // نرمي الخطأ ليعالجه الكنترولر
        }
    }
}

module.exports = AssetModel;