const jwt = require('jsonwebtoken');
require('dotenv').config();

function authenticateToken(req, res, next) {
    // البحث عن التوكن في الترويسة (Header)
    const authHeader = req.headers['authorization'];
    // التوكن يأتي عادة بالشكل: "Bearer <TOKEN>"
    const token = authHeader && authHeader.split(' ')[1];

    if (!token) {
        return res.status(401).json({ message: '⛔ يجب تسجيل الدخول أولاً' });
    }

    jwt.verify(token, process.env.JWT_SECRET, (err, user) => {
        if (err) {
            return res.status(403).json({ message: '⛔ جلسة غير صالحة أو منتهية' });
        }
        // إذا كان صحيحاً، نمرر بيانات المستخدم للمرحلة التالية
        req.user = user;
        next();
    });
}

module.exports = authenticateToken;