const db = require('../config/db');

class AgentController {

    static async receiveReport(req, res) {
        try {
            const data = req.body;
            console.log(`📡 استلام تقرير من الجهاز: ${data.hostname} (${data.mac})`);

            // 1. البحث عن الأصل بواسطة MAC Address (لأنه البصمة الفريدة)
            const [existing] = await db.query('SELECT * FROM assets WHERE mac_address = ?', [data.mac]);

            if (existing.length > 0) {
                // 2. تحديث البيانات (Update) إذا كان موجوداً
                const assetId = existing[0].id;
                await db.query(`
                    UPDATE assets SET 
                        name = ?, 
                        ip_address = ?, 
                        operating_system = ?, 
                        last_discovered = NOW(),
                        specifications = ?
                    WHERE id = ?
                `, [data.hostname, data.ip, data.os, JSON.stringify(data.specs), assetId]);
                
                return res.json({ status: 'updated', id: assetId });

            } else {
                // 3. إنشاء أصل جديد (Create)
                const [result] = await db.query(`
                    INSERT INTO assets (
                        code, name, category, branch, status, 
                        mac_address, ip_address, operating_system, 
                        manufacturer, model, serial_number, 
                        specifications, discovery_method, created_at
                    ) VALUES (?, ?, 'أجهزة كمبيوتر', 'الرياض', 'نشط', ?, ?, ?, ?, ?, ?, ?, 'Agent', NOW())
                `, [
                    'PC-' + Date.now().toString().slice(-6), // توليد كود تلقائي
                    data.hostname,
                    data.mac,
                    data.ip,
                    data.os,
                    data.manufacturer || 'Unknown',
                    data.model || 'Unknown',
                    data.serial || 'Unknown',
                    JSON.stringify(data.specs) // تخزين المواصفات كـ JSON
                ]);

                // تسجيل النشاط
                await db.query('INSERT INTO activity_logs (username, action, details) VALUES (?, ?, ?)', 
                    ['System Agent', 'اكتشاف', `تم اكتشاف جهاز جديد تلقائياً: ${data.hostname}`]);

                return res.json({ status: 'created', id: result.insertId });
            }

        } catch (error) {
            console.error('Agent Error:', error);
            res.status(500).json({ error: error.message });
        }
    }
}

module.exports = AgentController;