const mysql = require('mysql2');
require('dotenv').config();

// إنشاء مسبح الاتصالات (Connection Pool)
const pool = mysql.createPool({
    host: process.env.DB_HOST || 'localhost',
    user: process.env.DB_USER || 'wmashta',
    password: process.env.DB_PASSWORD || 'WalidPass28720',
    database: process.env.DB_NAME || 'asset_management_db',
    waitForConnections: true,
    connectionLimit: 10,
    queueLimit: 0
});

// تحويله لدعم Promises (async/await)
const db = pool.promise();

// اختبار الاتصال عند البدء
pool.getConnection((err, connection) => {
    if (err) {
        console.error('❌ خطأ في الاتصال بقاعدة البيانات:', err.message);
    } else {
        console.log('✅ تم الاتصال بقاعدة البيانات بنجاح!');
        connection.release();
    }
});

module.exports = db;