// ملف: reset_pass.js
const db = require('./src/config/db');
const bcrypt = require('bcrypt');

async function resetAdminPassword() {
    try {
        console.log('⏳ جاري تحديث كلمة المرور...');

        // 1. كلمة المرور الجديدة
        const newPassword = '123456';
        
        // 2. تشفير كلمة المرور
        const hashedPassword = await bcrypt.hash(newPassword, 10);

        // 3. تحديث قاعدة البيانات
        // نبحث عن المستخدم admin ونحدث كلمة مروره
        const [result] = await db.query(
            'UPDATE users SET password_hash = ? WHERE email = ?',
            [hashedPassword, 'admin@example.com']
        );

        if (result.affectedRows > 0) {
            console.log('✅ تم تحديث كلمة المرور بنجاح!');
            console.log('📧 البريد الإلكتروني: admin@example.com');
            console.log('🔑 كلمة المرور الجديدة: 123456');
        } else {
            console.log('❌ لم يتم العثور على المستخدم admin@example.com');
            // إذا لم يكن موجوداً، لنقم بإنشائه
            await db.query(
                'INSERT INTO users (username, email, password_hash, role) VALUES (?, ?, ?, ?)',
                ['admin', 'admin@example.com', hashedPassword, 'admin']
            );
            console.log('✨ تم إنشاء المستخدم Admin بنجاح بكلمة المرور 123456');
        }

    } catch (error) {
        console.error('❌ حدث خطأ:', error);
    } finally {
        process.exit(); // إغلاق البرنامج
    }
}

resetAdminPassword();