const loginForm = document.getElementById('loginForm');
const otpForm = document.getElementById('otpForm');
const messageBox = document.getElementById('messageBox');

let currentUserId = null; // سنحفظه مؤقتاً بين المرحلتين

// دالة مساعدة لعرض الرسائل
function showMessage(msg, type = 'error') {
    messageBox.textContent = msg;
    messageBox.className = `mt-4 text-center text-sm font-semibold p-2 rounded ${type === 'error' ? 'text-red-600 bg-red-50' : 'text-green-600 bg-green-50'}`;
    messageBox.style.display = 'block';
}

// 1. معالجة إرسال الإيميل وكلمة المرور
loginForm.addEventListener('submit', async (e) => {
    e.preventDefault();
    
    const email = document.getElementById('email').value;
    const password = document.getElementById('password').value;

    try {
        const response = await fetch('/api/auth/login', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ email, password })
        });

        const data = await response.json();

        if (response.ok) {
            // نجاح المرحلة الأولى
            showMessage(data.message, 'success');
            currentUserId = data.userId; // حفظ ID المستخدم
            
            // تبديل النماذج
            loginForm.classList.add('hidden-form');
            otpForm.classList.remove('hidden-form');
        } else {
            showMessage(data.message || 'حدث خطأ ما', 'error');
        }
    } catch (error) {
        showMessage('فشل الاتصال بالسيرفر', 'error');
    }
});

// 2. معالجة إرسال رمز OTP
otpForm.addEventListener('submit', async (e) => {
    e.preventDefault();
    
    const otpCode = document.getElementById('otpCode').value;

    try {
        const response = await fetch('/api/auth/verify-otp', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ userId: currentUserId, otpCode })
        });

        const data = await response.json();

        if (response.ok) {
            // نجاح تسجيل الدخول بالكامل!
            // 1. حفظ التوكن في LocalStorage
            localStorage.setItem('token', data.token);
            localStorage.setItem('user', JSON.stringify(data.user));

            showMessage('جاري تحويلك للوحة التحكم...', 'success');
            
            // 2. التوجيه للصفحة الرئيسية
            setTimeout(() => {
                window.location.href = '/dashboard.html';
            }, 1000);
        } else {
            showMessage(data.message || 'رمز غير صحيح', 'error');
        }
    } catch (error) {
        showMessage('فشل الاتصال بالسيرفر', 'error');
    }
});