const si = require('systeminformation');
const axios = require('axios');

// إعدادات السيرفر (يجب تغيير IP عند النشر في الشبكة)
const SERVER_URL = 'http://localhost:3000/api/assets/agent/report';

async function collectDataAndSend() {
    try {
        console.log('🔍 جاري جمع بيانات الجهاز...');

        // 1. جمع المعلومات
        const osInfo = await si.osInfo();
        const system = await si.system();
        const cpu = await si.cpu();
        const mem = await si.mem();
        const net = await si.networkInterfaces();

        // البحث عن أول كرت شبكة نشط للحصول على الـ MAC و IP
        const activeNet = net.find(n => !n.internal && n.mac) || net[0];

        // 2. تجهيز حزمة البيانات
        const payload = {
            hostname: osInfo.hostname,
            os: `${osInfo.distro} ${osInfo.release}`,
            manufacturer: system.manufacturer,
            model: system.model,
            serial: system.serial, // يحتاج صلاحيات مسؤول (Admin) في ويندوز أحياناً
            mac: activeNet.mac,
            ip: activeNet.ip4,
            specs: {
                cpu: `${cpu.manufacturer} ${cpu.brand} (${cpu.cores} Cores)`,
                ram: `${(mem.total / 1024 / 1024 / 1024).toFixed(1)} GB`,
                architecture: osInfo.arch
            }
        };

        console.log('📦 البيانات المجمعة:', payload);

        // 3. الإرسال للسيرفر
        console.log('📡 جاري الاتصال بالسيرفر...');
        const response = await axios.post(SERVER_URL, payload);

        console.log('✅ تم الإرسال بنجاح:', response.data);

    } catch (error) {
        console.error('❌ حدث خطأ:', error.message);
        if (error.code === 'ECONNREFUSED') {
            console.error('⚠️  تأكد أن السيرفر يعمل ويمكن الوصول إليه');
        }
    }
}

// تشغيل الوظيفة
collectDataAndSend();

// (اختياري) جدولة الإرسال كل 1 ساعة
// setInterval(collectDataAndSend, 3600000);